#include "Pole.h"
#include "Level.h"


Pole::Pole()
{
	setCollider(true);
	spriteType = SpriteType::PoleSprite;

	spriteTexture.loadFromFile("Assets/Sprites/Game Items/Flag/pole.png");	//Load the pole texture
	setTexture(&spriteTexture);
	setSize(sf::Vector2f(28, 521));
	setCollisionBox(sf::FloatRect(11, 0, 6, 526));
}


Pole::~Pole()
{
}

void Pole::handleCollision(MySprite* sprite, float dt)
{
	Timer::timerStopped = true;

	Mario* mario = (Mario*)sprite;

	if (!gotPositionScore)	//If we don't already have the score for where Mario landed on the pole
	{
		slideFlag = true;	//If we touch the pole, we want the flag to begin sliding
		Level::audioManager->stopAllMusic();
		Level::audioManager->playSoundByName("FlagMove");
		mario->addScore(getScoreForPosition(mario, mario->getPosition().y));	//Add the return value of getScoreForPosition to Mario's score
		gotPositionScore = true;	//We now have the score so set gotPositionScore to true. This prevents us adding score for each frame Mario is colliding with the pole.
	}
	
	mario->slideDownPole();	//Slide Mario down the pole

	if (Timer::setWaitTime(2, dt))	//If 2 seconds have passed (the flag will definitely be at the bottom)
	{
		mario->setWon(true);	//Mario has won, so walkToCastle can now be called
	}
}

int Pole::getScoreForPosition(Mario* mario, int position)
{
	//We separate into different "chunks" of y position, rewarding more points for the lower Mario's y position is (i.e. the higher up the flag he is)

	if (position > 453)
	{
		return 100;
	}

	else if (position <= 453 && position > 366)
	{
		return 400;
	}

	else if (position <= 366 && position > 279)
	{
		return 800;
	}

	else if (position <= 279 && position > 192)
	{
		return 4000;
	}

	else if (position <= 192)
	{
		mario->addLife();
		return 8000;
	}
}